/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.breakpoints;

class HitCounter {
    private final int threshold;
    private transient int countdown;
    public static final HitCounter INACTIVE = new HitCounter(){

        final StringBuffer appendDetail(StringBuffer stringBuffer) {
            return stringBuffer;
        }

        final boolean hit() {
            return true;
        }

        final void reset() {
        }
    };
    private static final HitCounter ACTIVE_1 = new HitCounter(1){

        final boolean hit() {
            return true;
        }

        final void reset() {
        }
    };

    public static final HitCounter getCounter(int n) {
        return n <= 0 ? INACTIVE : (n == 1 ? ACTIVE_1 : new HitCounter(n));
    }

    public static final HitCounter convertCounter(HitCounter hitCounter, int n) {
        return hitCounter.getThreshold() == n ? hitCounter : HitCounter.getCounter(n);
    }

    private HitCounter(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The threshold must be strictly positive");
        }
        this.threshold = n;
        this.reset();
    }

    private HitCounter() {
        this.threshold = 0;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final boolean isActive() {
        return this.getThreshold() > 0;
    }

    public final boolean isThresholdReached() {
        return this.countdown <= 0;
    }

    void reset() {
        this.countdown = this.getThreshold();
    }

    boolean hit() {
        return --this.countdown <= 0;
    }

    StringBuffer appendDetail(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(" - ");
        }
        return stringBuffer.append("HitCount:").append(this.getThreshold());
    }

    /* synthetic */ HitCounter(HitCounter hitCounter) {
        this();
    }

    /* synthetic */ HitCounter(int n, HitCounter hitCounter) {
        this(n);
    }
}

